package org.codefilarete.stalactite.sql.derby.ddl;


import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.Column;

/**
 * @author Guillaume Mary
 */
public class DerbyDDLTableGenerator extends DDLTableGenerator {
	
	public DerbyDDLTableGenerator(SqlTypeRegistry typeMapping, DMLNameProviderFactory dmlNameProviderFactory) {
		super(typeMapping, dmlNameProviderFactory);
	}
	
	/**
	 * Overridden to take identity column into account : Derby script must be adapted
	 */
	@Override
	protected String getSqlType(Column column) {
		String sqlType = super.getSqlType(column);
		if (column.isAutoGenerated()) {
			sqlType += " GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1)";
		}
		return sqlType;
	}
}
